/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug.swing;

import frc.emul.vectrex.debug.UITraceEntries;
import frc.emul.vectrex.debug.UITraceEntry;
import javax.swing.table.DefaultTableModel;

public class BackTraceTableModel
extends DefaultTableModel {
    public static final int NB_REGS = 9;
    static final int COL_CODE_BANK = 0;
    static final int COL_CODE_DATA = 1;
    static final int COL_CODE_SRC = 2;
    static final int COL_CODE_COMMENT = 3;
    static final int COL_REGS = 4;
    static final int COL_STACK = 13;
    private static final int NB_COLS = 14;
    private UITraceEntries model;

    public BackTraceTableModel(UITraceEntries uITraceEntries) {
        this.model = uITraceEntries;
    }

    public int getRowCount() {
        return this.model == null ? 0 : this.model.getSize();
    }

    public int getColumnCount() {
        return 14;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Bank";
            }
            case 1: {
                return "Code Bytes";
            }
            case 2: {
                return "Code Source";
            }
            case 3: {
                return "Code Comment";
            }
            case 13: {
                return "Stack";
            }
        }
        return UITraceEntry.getRegisterKind(n - 4).getName();
    }

    public Object getValueAt(int n, int n2) {
        UITraceEntry uITraceEntry = this.model.getUIEntry(n);
        switch (n2) {
            case 0: {
                return Integer.toString(uITraceEntry.getEntry().getBank());
            }
            case 1: {
                return uITraceEntry.getCodeBytes();
            }
            case 2: {
                return uITraceEntry.getCodeSource();
            }
            case 3: {
                return uITraceEntry.getCodeComments();
            }
            case 13: {
                return uITraceEntry.getStack();
            }
        }
        return uITraceEntry.getRegisters()[n2 - 4];
    }
}

